package jadean.dean.java.utilities;

import jadean.dean.Resource;
import jadean.dean.java.JavaProject;
import jadean.dean.java.JavaResource;

import java.util.Collection;
import java.util.HashSet;


public class ProjectUtilities {
	/**
	 * Method removes duplicates in array of JavaResource objects
	 * by removing short class names if fully qualified class name is in the list
	 * and the fully qualified class name is imported
	 * @param resources
	 * @return
	 */
	public static Collection<Resource> deDuplicateResources(Collection<Resource> resources) {
		HashSet<Resource> deDuplicatedResources = new HashSet<Resource>(resources);
		for (Resource _resource1: resources) {
			JavaResource resource1 = (JavaResource) _resource1;
			for (Resource _resource2: resources) {
				JavaResource resource2 = (JavaResource) _resource2;
				String shortClassName2 = JavaUtilities.extractClassName(resource2.getName());
				
				if ((shortClassName2.equals(resource1.getName()) 
					&& resource1.getContext().getClassImportedClasses().contains(resource2.getName())) ||
					(resource1.getName().startsWith(resource2.getName().replace(".*", "")) && !resource1.getName().equals(resource2.getName()))) {
					deDuplicatedResources.remove(resource1);
				}
			}
		}
		return deDuplicatedResources;
	}
	
	public static Collection<Resource> removeResourcesFromPackage(Collection<Resource> resources) {
		HashSet<Resource> deDuplicatedResources = new HashSet<Resource>(resources);
		for (Resource resource1: resources) {
			for (Resource resource2: resources) {
				if (resource2.getName().endsWith(".*") && (resource1.getName().startsWith(resource2.getName().replace(".*", "")) && !resource1.getName().equals(resource2.getName()))) {
					deDuplicatedResources.remove(resource1);
				}
			}
		}
		return deDuplicatedResources;
	}	
	
	/**
	 * Method normalizes list of JavaResource objects
	 * by replacing the short class name with fully qualified class name if possible 
	 * @param resources to normalize
	 * @param project
	 * @return normalized list of resources
	 */
	public static Collection<Resource> normalizeResources(Collection<Resource> resources, JavaProject project) {
		HashSet<Resource> normalizedResources = new HashSet<Resource>(resources);
		for (Resource resource: resources) {
			JavaResource javaResource = (JavaResource) resource;
			for (String importedPackage: javaResource.getContext().getClassImportedPackages()) {
				String fullyQualifiedClassName = JavaUtilities.buildFullyQualifiedClassName(importedPackage, javaResource.getName());
				if (project.isContainedInReferencedPackages(fullyQualifiedClassName)) {
					javaResource.setName(fullyQualifiedClassName);
				}
				if (project.isContainedInProjectFolders(fullyQualifiedClassName)) {
					javaResource.setName(fullyQualifiedClassName);
				}
			}
		}
		return normalizedResources;
	}
}
